package abstraction;
/**
 * @author Chiara Coccia, Diego Colarullo
 * @version 1.3 09/03/18
 * @since JDK 1.6
 */
import java.io.*; 

/**
 * This class is useful to take a service and to read it. Accepted format are pdf, doc, docx, txt, aut and dot.
 * Before reading file is checked and if it is correct it is possible read it otherwise if there is/are error/s
 * these are shown in console reporting line and type error. 
 */
public class ReadFile {
	private static String filename, typeError;
	private static boolean ioError;
	static int errorLine;
	
	/**
	 * 
	 * @param fn file's name to assign
	 */
	public static void setFileName(String fn){
		filename = fn;
	}
	
	
    /**
     * this method check file's correctness (file parser) 
     * @param filename
     * @param content
     * @return a boolean true if document is correct flase otherwise
     * @throws WrongFileException 
     * @throws IOException 
     * @throws Exception during reading file
     */
     private static boolean checkFile(String filename, String content) throws WrongFileException, IOException, NullPointerException{
		
	  BufferedReader in;
      boolean transitionCheck,firstLineCheck,check, otherLine, finalCheck, lastLineCheck,finalStateLineCheck,finalCheck2,initialLine,initialCheck,accessToFinal, initialStateLineCheck;
      transitionCheck=firstLineCheck=otherLine=finalCheck=finalCheck2=finalStateLineCheck=lastLineCheck=initialLine=initialCheck=accessToFinal=initialStateLineCheck=false;
      
      int firstLine,lastLine,countLine;
      firstLine=lastLine=countLine=0;
        
      String verifyfinalState=new String("");
	  errorLine=0;
	  ioError=false;    
	  typeError= new String("");       
    	
//*****************************************************************************************************************************************************        
//******************************************************* 1 control=>if there isn't a pdf file *******************************************************
//*****************************************************************************************************************************************************  	
      try{
    	if(content.equals("")){      		
    			in = new BufferedReader(new FileReader(filename));
    			String str;				
    			loop:while ((str = in.readLine()) != null) {   
    				firstLine++;	
    				str=str.trim();
    				
    				if (str.length() == 0) {
    					//if i haven't already check the first line and the beginning lines are blank the iterator is set to zero
						if(!firstLineCheck){
							countLine++;
							firstLine = 0;
						}
							
        				continue loop; 
        			}
    				
    				//this control is useful to check if first line is equals to transition:
                    if(str.startsWith("transition:") && str.endsWith("transition:") && str.indexOf("transition:")==str.lastIndexOf("transition:") && !firstLineCheck && firstLine==1){
                    	    firstLine = firstLine + countLine;
                    		firstLineCheck=true;
                    	    transitionCheck=true;
                    		continue loop;
                    }
                    
                    if(!firstLineCheck){
                    	ReadFile.errorLine=firstLine;
                    	ReadFile.typeError = ": File must begin with transition: word.";
                    	break loop;
                    }
                    
                    
                    //this control is useful to check if there is final: line 
                    if(str.startsWith("initial:")){              	
                    	transitionCheck=false;
                    	if(str.endsWith("initial:") && str.indexOf("initial:")==str.lastIndexOf("initial:") && !initialLine){              	
    	                	initialCheck = true;
    	                	initialLine = true;
    	                	accessToFinal=true;
                    	}
                    	continue loop;
                    }                                       
                    
                    
                    
                    
                    //this control is useful to check from secondline to lastTrasaction
                    if(transitionCheck){                	
                    	int index = str.indexOf("-");
                    	
                    	/*
                    	 * it is present the - && the present state isn't empty 
                    	 * */
                    	if(index!=-1 && !str.substring(0, index).equals("") && !str.contains(",") && !str.contains(".") ){
                    		int index2 = str.indexOf(";");
                        	String str2 = str.substring(index+1, index2);
                        	
                        	/*
                        	 * contains - && contains only one - &&
                        	 * the action isn't empty && there isn't nothing written after ; &&
                        	 * there aren't spaces in the definition of transition && states and actions' name aren't final or transition &&
                        	 * the next state isn't empty
                        	 * */
            				if(str2.contains("-") && str2.lastIndexOf("-")==str2.indexOf("-") && 
            				   !str2.substring(0, str2.indexOf("-")).equals("") && str.substring(index2+1).equals("") && 
            				   str.indexOf(" ")==-1 && !str.contains("final") && !str.contains("transition") && 
            				   !str2.substring(str2.indexOf("-")+1).equals("")){            					            					            					
            					
            					verifyfinalState= verifyfinalState+str.substring(0,index)+str.substring(str.lastIndexOf("-")+1,index2);
           					            					
            				    otherLine=true;
            				    continue loop;
            				}
            				else{
            					otherLine =false;
            					ReadFile.errorLine=firstLine;
            					ReadFile.typeError = ": A right transition must be written like this: presentState-action-nextState; and not contain final or transition word.";
            					break loop;
            				}
                    	}
                    	else{
                    		otherLine =false;
                    		ReadFile.errorLine=firstLine;
                    		ReadFile.typeError = ": A right transition must be written like this: presentState-action-nextState; and not contain final or transition word.";
                        	break loop;
                    	}
                    	
        				
                    }
                    
                    if(!initialCheck){
                    	ReadFile.errorLine=firstLine;
                    	ReadFile.typeError = ": File must has the line initial:";
                    	break loop;
                    }                    
                    
                  //this control is useful to check if there is final: line 
                    if(str.startsWith("final:") && initialStateLineCheck){
                    	initialLine=false;
                    	if(str.endsWith("final:") && str.indexOf("final:")==str.lastIndexOf("final:") && !lastLineCheck){              	
    	                	finalCheck = true;
    	                	lastLineCheck = true;
                    	}
                    	continue loop;
                    }

                    if(initialLine){
                    	int index = str.indexOf(";");
                    	//if contains ;
                    	if(index!=-1){
                    		if(str.substring(index+1).equals("") && !str.substring(0,index).equals("") && 
         	    				   str.indexOf(" ")==-1 && str.indexOf(",")==-1 && !str.contains("final") && 
         	    				   !str.contains("transition") && !str.contains("initial") ){
                    			if(verifyfinalState.contains(str.substring(0, index))){
                        			initialStateLineCheck=true;
    		    				    continue loop;
                    			}
                    			else{
    		    					initialStateLineCheck =false;
    		    					ReadFile.errorLine=firstLine;
    		    					ReadFile.typeError = ": A initial state must be a state";
    		    					break loop;                    				
                    			}	    				    
                    		}
                    		else{
		    					initialStateLineCheck =false;
		    					ReadFile.errorLine=firstLine;
		    					ReadFile.typeError = ": A initial state must be written like this: initialState; ";
		    					break loop;
                    		}                    		
                    	}
                    	else{
                    		int line=ReadFile.errorLine=firstLine;
                    		throw new WrongFileException("Wrong Content File. Please Check it.\n"+"      ["+filename+"]"+" Error line "+line+": A initial state must terminare with ;");                    	
                    	}
                    }
                    
                    if(!lastLineCheck){
                    	ReadFile.errorLine=firstLine;
                    	ReadFile.typeError = ": File must has the line final:";
                    	break loop;
                    }
                
                    
                    	                
                    //this control is useful to check finalStates
                    if(finalCheck && lastLine==0){
                    	int index = str.indexOf(";");
                     	int index2 = str.indexOf("."); 
                     	
                     	//if contains ;
                    	if(index!=-1){
                    		/*
                        	 * there isn't nothing written after ; && the state isn't empty && 
                        	 * there aren't spaces and comma in the row && 
                        	 * to verify final state exists like a state  
                        	 * states and actions' name aren't final or transition
                        	 * */
    	    				if(str.substring(index+1).equals("") && !str.substring(0,index).equals("") && 
    	    				   str.indexOf(" ")==-1 && str.indexOf(",")==-1 && 
    	    				   verifyfinalState.contains(str.substring(0, index)) && 
    	    				   !str.contains("final") && !str.contains("transition") && !str.contains("initial")){
    	    					
    		    					finalStateLineCheck=true;
    		    				    continue loop;
    	    				    
    	    				}
    	    				else{
    		    					finalStateLineCheck =false;
    		    					ReadFile.errorLine=firstLine;
    		    					ReadFile.typeError = ": A final state must be written like this: finalState; or final state must be a state.";
    		    					break loop;
    	    				}    
                    	}
                    	else{
                    		//if contains .
                    		if(index2!=-1){
                    			/*
                            	 * there isn't nothing written after . && the state isn't empty && 
                            	 * there aren't spaces and comma in the row && 
                            	 * to verify final state exists like a state  
                            	 * states and actions' name aren't final or transition
                            	 * */
                    			if(str.substring(index2+1).equals("") && !str.substring(0,index2).equals("") && 
                    			   str.indexOf(" ")==-1 && str.indexOf(",")==-1 && 
                    			   verifyfinalState.contains(str.substring(0, index2)) && 
                    			   !str.contains("final") && !str.contains("transition")){
                    				
    	                				finalStateLineCheck=true; 
    	                				finalCheck=false;
    	                				lastLine = firstLine;
                    			}
                    			else{
    	                				finalStateLineCheck=false;
    	                				ReadFile.errorLine=firstLine;
    	                				ReadFile.typeError = ": The last final state must be written like this: finalState. or final state must be a state.";
    	                				break loop;
                    			}
                            }
                    		else{
                    			finalStateLineCheck=false;
                    			ReadFile.errorLine=firstLine;
                    			ReadFile.typeError = ": A final state must terminate with ; or with . if it's the last line.";
                    		    break loop;
                    		}
                    	}
                    	
                    }
                    
    		    }
    			in.close();	       		
    		
    		//this control is useful to check after the dot there isn't nothing
    		if(lastLine==firstLine)
    			finalCheck2=true;
    		else
    			if(lastLine!=0){
    				ReadFile.errorLine=lastLine+1;
    				ReadFile.typeError = ": The file must end with . or with existent final state and .";
    			}
    			else{
    				if(accessToFinal && initialStateLineCheck){
    					ReadFile.errorLine=firstLine+1;
    					if(ReadFile.typeError.equals(""))
    						ReadFile.typeError =": The file must contain final states and last must end with .";
    				}
    				else{
    					ReadFile.errorLine=firstLine;  								    					
    					if(firstLineCheck && !transitionCheck)
    						if(ReadFile.typeError.equals(""))
    						   ReadFile.typeError =": The file must contain initial states";
    				}
    		   }
    	}
    	//first generic else
    	else{
//***************************************************************************************************************************************************
//*******************************************************2 control=>if there is a pdf file**********************************************************
//***************************************************************************************************************************************************    	
    	//second generic if
    	if(!content.equals("") && content.contains(".")){   		
    			String str=content;		
    			String verifyLast="";	    			
    			content="";     			
    			loop:while (str.length()!=0) {  
				    				
    				firstLine++;	
    				
    				if(str.contains("\n"))
    					content=str.substring(0, str.indexOf("\n")-1);
    				else
    					content=str;
    				
    				//this control check if there are blank space at line's end or if the line is totally blank 
    				//if it is so this spaces are take off from the line and if the line is empty it's ignored
    				if(content.substring(content.length()-1).equals(" "))
    					content = content.substring(0, content.indexOf(" ")).trim();  
    					if(content.equals("")){
    						str = str.substring(str.indexOf("\n")+1);
    						//if i haven't already check the first line and the beginning line are blank the iterator is set to zero
    						if(!firstLineCheck)
    							firstLine = 0;
    						else
    							countLine++;
    						continue loop;
    					}
    				    				 				
    				//this control is useful to check if first line is equals to transition:
                    if(content.startsWith("transition:") && 
                       content.endsWith("transition:") && 
                       content.indexOf("transition:")==content.lastIndexOf("transition:") && 
                       !firstLineCheck && firstLine==1){
                    	    firstLineCheck=true;
                    	    transitionCheck=true;  
                            str = str.substring(str.indexOf("\n")+1);
                    		continue loop;
                    		
                    }
                    
                    if(!firstLineCheck){
                    	ReadFile.errorLine=firstLine-countLine;
                    	ReadFile.typeError = ": File must begin with transition word.";
                    	ioError = false;                    	
                    	break loop;
                    }
                    
                  //this control is useful to check if there is final: line 
                    if(content.startsWith("initial:")){               	
                    	transitionCheck=false;
                    	if(content.endsWith("initial:") && content.indexOf("initial:")==content.lastIndexOf("initial:") && !initialLine){              	
    	                	initialCheck = true;
    	                	initialLine = true;
    	                	accessToFinal=true;
                    	}
                        str = str.substring(str.indexOf("\n")+1);                         
                    	continue loop;
                    }
                    
                    //this control is useful to check from secondline to lastTrasaction
                    if(transitionCheck){                      	
                    	int index = content.indexOf("-");
                    	
                    	/*
                    	 * it is present the - && the present state isn't empty 
                    	 * */
                    	if(index!=-1 && !content.substring(0, index).equals("") && !content.contains(",") && !content.contains(".")){
                    		int index2 = content.indexOf(";");
                        	String str2 = content.substring(index+1, index2);
                        	
                        	/*
                        	 * contains - && contains only one - &&
                        	 * the action isn't empty && there isn't nothing written after ; &&
                        	 * there aren't spaces in the definition of transition && states and actions' name aren't final or transition &&
                        	 * the next state isn't empty
                        	 * */
            				if(str2.contains("-") && str2.lastIndexOf("-")==str2.indexOf("-") && 
            				   !str2.substring(0, str2.indexOf("-")).equals("") && content.substring(index2+1).equals("") && 
            				   content.indexOf(" ")==-1 && !content.contains("final") && !content.contains("transition") && 
            				   !str2.substring(str2.indexOf("-")+1).equals("")){
            					
            					verifyfinalState= verifyfinalState+content.substring(0,index)+content.substring(content.lastIndexOf("-")+1,index2);;    
            					            					
            				    otherLine=true;
                                str = str.substring(str.indexOf("\n")+1);                				    
            				    continue loop;
            				}
            				else{
            					otherLine =false;
            					ReadFile.errorLine=firstLine-countLine;
            					ReadFile.typeError = ": A right transition must be written like this: presentState-action-nextState; and not contain final or transition word.";
            					ioError = false;
            					break loop;
            				}
                    	}
                    	else{             
                    		otherLine =false;
                    		ReadFile.errorLine=firstLine-countLine;
                    		ReadFile.typeError = ": A right transition must be written like this: presentState-action-nextState; and not contain final or transition word.";
                    		ioError = false;
                    		break loop;
                    	}    
                    }
                    
                    if(!initialCheck){
                    	ReadFile.errorLine=firstLine;
                    	ReadFile.typeError = ": File must has the line initial:";
                    	break loop;
                    }                    
                    
                  //this control is useful to check if there is final: line 
                    if(content.startsWith("final:") && initialStateLineCheck){
                    	initialLine=false;
                    	if(content.endsWith("final:") && content.indexOf("final:")==content.lastIndexOf("final:") && !lastLineCheck){              	
    	                	finalCheck = true;
    	                	lastLineCheck = true;
                    	}
                        str = str.substring(str.indexOf("\n")+1);                      	
                    	continue loop;
                    }

                    if(initialLine){
                    	int index = content.indexOf(";");
                    	//if contains ;
                    	if(index!=-1){
                    		if(content.substring(index+1).equals("") && !content.substring(0,index).equals("") && 
                    				content.indexOf(" ")==-1 && content.indexOf(",")==-1 && !content.contains("final") && 
         	    				   !content.contains("transition") && !content.contains("initial") ){
                    			if(verifyfinalState.contains(content.substring(0, index))){
                        			initialStateLineCheck=true;
                                    str = str.substring(str.indexOf("\n")+1);                                     
    		    				    continue loop;
                    			}
                    			else{
    		    					initialStateLineCheck =false;
    		    					ReadFile.errorLine=firstLine;
    		    					ReadFile.typeError = ": A initial state must be a state";
    		    					break loop;                    				
                    			}	    				    
                    		}
                    		else{
		    					initialStateLineCheck =false;
		    					ReadFile.errorLine=firstLine;
		    					ReadFile.typeError = ": A initial state must be written like this: initialState; ";
		    					break loop;
                    		}                    		
                    	}
                    	else{
                    		int line=ReadFile.errorLine=firstLine;
                    		throw new WrongFileException("Wrong Content File. Please Check it.\n"+"      ["+filename+"]"+" Error line "+line+": A initial state must terminare with ;");                    	
                    	}
                    }                    
                    
                    if(!lastLineCheck){
                    	ReadFile.errorLine=firstLine-countLine;
                    	ReadFile.typeError = ": File must has the line final:";
                    	ioError = false;
                    	break loop;
                    }
                    	                
                    //this control is useful to check finalStates
                    if(finalCheck && lastLine==0){                 	
                    	int index = content.indexOf(";");
                     	int index2 = content.indexOf("."); 
                     	
                     	//if contains ;
                    	if(index!=-1){
                    		/*
                        	 * there isn't nothing written after ; && the state isn't empty && 
                        	 * there aren't spaces and comma in the row && 
                        	 * to verify final state exists like a state  
                        	 * states and actions' name aren't final or transition
                        	 * */
    	    				if(content.substring(index+1).equals("") && !content.substring(0,index).equals("") && 
    	    				   content.indexOf(" ")==-1 && content.indexOf(",")==-1 && 
    	    				   verifyfinalState.contains(content.substring(0, index)) && 
    	    				   !content.contains("final") && !content.contains("transition")){
    	    					
    		    					finalStateLineCheck=true;
    	                            str = str.substring(str.indexOf("\n")+1);     
    		    				    continue loop;    	    				    
    	    				}
    	    				else{
    		    					finalStateLineCheck =false;
    		    					ReadFile.errorLine=firstLine-countLine;
    		    					ReadFile.typeError = ": A final state must be written like this: finalState; or final state must be a state.";
    		    					ioError = false;
    		    					break loop;
    	    				}    
                    	}
                    	else{
                    		//if contains .
                    		if(index2!=-1){
                    			/*
                            	 * there isn't nothing written after . && the state isn't empty && 
                            	 * there aren't spaces and comma in the row && 
                            	 * to verify final state exists like a state  
                            	 * states and actions' name aren't final or transition
                            	 * */
                    			if(content.substring(index2+1).equals("") && !content.substring(0,index2).equals("") && 
                    			   content.indexOf(" ")==-1 && content.indexOf(",")==-1 && 
                    			   verifyfinalState.contains(content.substring(0, index2)) && 
                    			   !content.contains("final") && !content.contains("transition")){
                    				
    	                				finalStateLineCheck=true; 
    	                				finalCheck=false;
    	                				lastLine = firstLine;    	                				
    	                				verifyLast=str.substring(str.indexOf("\n")+1);
    	                				str="";
  	                				
 	                				
                    			}
                    			else{
    	                				finalStateLineCheck=false;
    	                				ReadFile.errorLine=firstLine-countLine;
    	                				ReadFile.typeError = ": The last final state must be written like this: finalState. or final state must be a state.";
    	                				str = str.substring(str.indexOf("\n")+1);
    	                				ioError = false;
    	                				break loop;
                    			}
                            }
                    		else{
                    			finalStateLineCheck=false;
                    			ReadFile.errorLine=firstLine-countLine;
                    			ReadFile.typeError = ": A final state must terminate with ; or with . if it's the last line.";
                    			ioError = false;
                    			str = str.substring(str.indexOf("\n")+1);
                    			break loop;
                    		}
                    	}
                    	
                    }
                    
    		    }      		    			

    		//this control is useful to check after the dot there isn't nothing
    		if(verifyLast.equals(""))
    			finalCheck2=true;
    		else
    			if(lastLine!=0){
    				ReadFile.errorLine=lastLine+1-countLine;
    				ReadFile.typeError = ": The file must end with . or with existent final state and .";
    				ioError = false;    				
    			}
    			else{
    				if(accessToFinal && initialStateLineCheck){
    					ReadFile.errorLine=firstLine+1;
    					if(ReadFile.typeError.equals(""))
    						ReadFile.typeError =": The file must contain final states and last must end with .";
    				}
    				else{
    					ReadFile.errorLine=firstLine;  								    					
    					if(firstLineCheck && !transitionCheck)
    						if(ReadFile.typeError.equals(""))
    						   ReadFile.typeError =": The file must contain initial states";
    				}
    				ioError=false;
    		   }
    	}   
    	//else second if (row 293)
    	else{
			ioError = true;
			throw new WrongFileException("Wrong Content File. Please Check it.\n"+"      ["+filename+"]"+" File must termite with . or content line final:");
			//System.err.println("Wrong Content File. Please Check it.\n"+"      ["+filename+"]"+" File must termite with . or content line final:\n"); 			     		
    	}
    	
    	//end first generic else (row 209)
    	}    		
	  }//end try
	  catch(IOException e){
			ioError = true;
			throw new IOException(filename+" not found.");
			//JOptionPane.showMessageDialog(null, filename+" not found.\n");
			//System.err.println(filename+" not found.\n");    			  		
	  }
	  catch(NullPointerException e){
			ioError = true;
			throw new NullPointerException(filename+" Null Pointer.\n");
			//JOptionPane.showMessageDialog(null, filename+" Null Pointer.\n");
			//System.err.println(filename+" Null Pointer.\n");    			  		
	  }    	    		
	  catch(ArrayIndexOutOfBoundsException e){
			ioError = true;
			throw new ArrayIndexOutOfBoundsException(filename+" Access with an illegal index. The index is either negative or greater than or equal to the size of the array.");
			//JOptionPane.showMessageDialog(null, filename+" Access with an illegal index. The index is either negative or greater than or equal to the size of the array.\n");
			//System.err.println(filename+" Access with an illegal index. The index is either negative or greater than or equal to the size of the array.\n");    			  		
	  }     	
				
	  //this variable will be true iff file is written right
	  check=firstLineCheck && otherLine && lastLineCheck && finalStateLineCheck && finalCheck2 && initialStateLineCheck;		
	  return check;
     }//end method

	/**
	 * this method read a right file with anything extension
	 * @return a string with content'file
	 * @throws WrongFileException 
	 * @throws IOException 
	 * @throws Exception during reading file
	 */
	public static String readFile() throws WrongFileException, IOException, NoClassDefFoundError, Exception{				        
        //this variable will store all file's content just reading
 		String contentFile="";
 		boolean pdfNotFound = false;
 		boolean otherExtention = false;
 		String extention = filename.substring(filename.lastIndexOf("."));
 		
 		if(extention.equals(".pdf")){
 			try {
				contentFile = ConvertPdf.GetTextFromPdf(filename);
			} 
 			catch (IOException e) {	
 				throw new IOException(filename+" not found.");
 				//JOptionPane.showMessageDialog(null, filename+" not found.\n");
 				//System.err.println(filename+" not found.\n"); 				
 			}		
 			catch (NoClassDefFoundError e) {				
 				throw new NoClassDefFoundError(filename+" not found.");
 				//JOptionPane.showMessageDialog(null, filename+" Wrong file format. Please rewrite it.\n");
 				//System.err.println(filename+" Wrong file format. Please rewrite it.\n");
 			}						
 			
 			if(contentFile.equals(""))
 				pdfNotFound = true;
 		}
 		else 		
 			//the variable is true iff the extention of our file isn't a textual extention
 			if(!extention.equals(".doc") && !extention.equals(".docx") && !extention.equals(".txt") && !extention.equals(".aut") && !extention.equals(".dot"))
 				otherExtention = true;

 		
 		if(!otherExtention){
 			if(!pdfNotFound){
 				if(checkFile(filename, contentFile)){
		 			
		 			//if there isn't a pdf file in input
		 			if(contentFile.equals("")){		 					
		 	 		    try { 		    	 		    	
		 	 		    	BufferedReader in = new BufferedReader(new FileReader(filename));
		 	 		    	String str;
		
		 	 		        while ((str = in.readLine()) != null) {	        		            
		 	 		        	str = str.trim();
		 	 		        	contentFile=contentFile+str;	        	
		 	 		        }	
		 	 			    in.close();	 	    	
		 	 		    }
		 	 		    catch (IOException e) {} 
		 			}
		 			//if there is a pdf file in input 			
		 			else{ 				
 						String str=contentFile;	 	
			 		    	
		 		    	contentFile="";
		 		    	while ((str.length())!=0) {	
	 	 		        
	 	 		        	str = str.trim();	 	 		        	
	 	 		        	if(str.contains("\n")){
		 	 		        	contentFile=contentFile+str.substring(0, str.indexOf("\n")-1).trim();		 	 		        	
	                            str = str.substring(str.indexOf("\n")+1);
	 	 		        	}			 	 		        	
	 	 		        	else{
		 	 		        	contentFile=contentFile+str;
	                            str = str.substring(str.indexOf(".")+1);                        
	 	 		        	} 
	 	 		        } 		 	 		        	 	 		
		 			} 									 		
		 		}//end if row 621
		 		else{
		 			if(!ioError){		 
		 				if(ReadFile.errorLine==0){
		 					throw new WrongFileException("File is empty. Please check it");
		 				}
		 				else{
		 					if(ReadFile.typeError.equals(""))
		 						ReadFile.typeError=": Add other transitions or a initial state.";
			 				throw new WrongFileException("Wrong Content File. Please Check it.\n"+"      ["+filename+"]"+" Error line "+(ReadFile.errorLine+1)+ReadFile.typeError);
			 				//System.err.println("Wrong Content File. Please Check it.\n"+"      ["+filename+"]"+" Error line "+ReadFile.errorLine+ReadFile.typeError); 		 					
		 				}
					 			
		 			}
		 			contentFile="";
		 		}
 			}// end if row 620		 		
 		}//end if row 619
 		else{
 			throw new WrongFileException("File with "+extention+" extention not supported.");
 		}
	 		 		 		
 		filename = filename.substring(0, filename.lastIndexOf("."));
 		if(filename.contains("/"))
 			filename = filename.substring(filename.lastIndexOf("/")+1)+"?";
 		else
 			if(filename.contains("\\"))
 				filename = filename.substring(filename.lastIndexOf("\\")+1)+"?";
 	 		else
 	 			filename = filename+"?";
 		
 		//if file is correct this variable returns content's file otherwise it will be empty
	    return filename+contentFile;
		
	}	
}

